//
//  * tree_etu.c
//  * logMollo
//
//  * Created by Gwendal Le Tareau on 10/11/2022.
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "tree_etu.h"
#include "list.h"
// #include <math.h>





// arbre de huffman
// struct tree_node {
    

// };





// = gestion du tableau de codage des octets
// T_ Terminé

// * remet a zero le nombre d'occurrences des octets
void tree_resetByteOccurrence( struct byteCoding indexedCodeTable[256] )
{
    for (int i = 0 ; i < 256 ; i++)
    {
        indexedCodeTable[i].occurrence = 0;
        indexedCodeTable[i].byte = i;
    }
}

// * remet a zero les codes octet
void tree_resetByteCoding( struct byteCoding indexedCodeTable[256] )
{
    for (int i = 0 ; i < 256 ; i++)
    {
        indexedCodeTable[i].occurrence = 0;
        indexedCodeTable[i].huffmanCode = 0;
        indexedCodeTable[i].nbBits = 0;
        indexedCodeTable[i].byte = i;
    }
}

// * compte de nombre d'occurrence des octets dans un tampon
void tree_countByteOccurrence( const t_byte * buffer, int size, struct byteCoding indexedCodeTable[256] )
{
    for (int i = 0 ; i < size ; i++)
        indexedCodeTable[buffer[i]].occurrence++;
    
}

// * affiche la table de codage des valeurs d'octet pour debug
void tree_displayByteCoding(struct byteCoding indexedCodeTable[256])
{
    printf("occurr\tbyte\thuffman\tnbBits\n");
    for (int i = 0 ; i < 256 ; i++)
    {
        if (indexedCodeTable[i].occurrence != 0) // $$ À SUPPRIMER APRÈS
            printf("%d\t%d\t%d\t%d\n", indexedCodeTable[i].occurrence, indexedCodeTable[i].byte, indexedCodeTable[i].huffmanCode, indexedCodeTable[i].nbBits);
    }
}





// = gestion de l'arbre de Huffman
// E_ En cours

// * creation d'un noeud
struct tree_node * tree_createNode (struct tree_node * father, int * value )
{
    struct tree_node *tn = (struct tree_node*) malloc(sizeof(struct tree_node));

    if (tn == NULL)
        return NULL;
        
    tn->parentNode = father;
    tn->leftChildNode = NULL;
    tn->rightChildNode = NULL;
    tn->data = value;
    
    return tn;
    
}

// * creation d'un noeud de codage et liaison avec ses fils
struct tree_node * tree_createCodingNode ( struct tree_node * left, struct tree_node * right )
{
    
    struct tree_node *tn = (struct tree_node*) malloc(sizeof(struct tree_node));
    if (tn == NULL)
        return NULL;
    
    tn->leftChildNode = left;
    tn->rightChildNode = right;
    tn->parentNode = NULL;
    
    tn->data = (int *) malloc(sizeof(int));
    *(tn->data) = ((struct byteCoding*) left->data)->occurrence + ((struct byteCoding*) right->data)->occurrence;

    return tn;
}

// * creation de l'arbre
int compInt(s_node *s, struct tree_node* param)
{
    int *vsnode = GET_LIST_DATA(s, int*);
    int *vparam = (int*) param;

    if (*vsnode == *vparam) return 0;

    if (*vsnode < *vparam) return -1;

    return 1;
}
struct tree_node * tree_create ( struct byteCoding * indexedCodeTable )
{
    int tailleListe = 0;
    s_node *liste = list_create();
    s_node *rootListe = liste;
    for (int i = 0 ; i < 130 ; i++) // ! À remettre à 256 après
    {
        printf("i = %d / occurrence = %d / byte = %d / huffman = %d / nbBits = %d\n", i, indexedCodeTable[i].occurrence, indexedCodeTable[i].byte, indexedCodeTable[i].huffmanCode, indexedCodeTable[i].nbBits);
        if (indexedCodeTable[i].occurrence > 0)
        {
            printf("\tOK\n");
        
            struct tree_node *noeud = tree_createNode(NULL, (int *) &indexedCodeTable[i]);
        
            list_orderedAppend(&liste, &compInt, noeud);
            
            tailleListe++;
        }
    }

    
    
    // struct tree_node *droit = tree_createNode(NULL, liste->data);
    // struct tree_node *pere;
    
    
    struct tree_node *precNode = liste->data;
    for (int i = 0 ; i < tailleListe-1 ; i++)
    {
        liste = liste->next;
        struct tree_node *node = tree_createCodingNode(liste->data, precNode);
        precNode = node;
    }
    
    return precNode;

}

// * destruction d'un arbre et liberation des donnees (sauf au niveau des feuilles)
void tree_destroy( struct tree_node * root );
    
// * construit les codes de huffman en parcourant l'arbre
void tree_buildHuffmanCode(struct tree_node * root, int level, int code)
{
    int codeActuel = 0;
    int nbBits = 1;
    struct tree_node *noeudCourant = root;
    
    while (noeudCourant->leftChildNode != NULL && noeudCourant->rightChildNode != NULL)
    {
        ((struct byteCoding*) noeudCourant->leftChildNode->data)->huffmanCode = code*10;
        ((struct byteCoding*) noeudCourant->leftChildNode->data)->nbBits = nbBits;
        noeudCourant = noeudCourant->rightChildNode;
        code = code*10+1;
        ((struct byteCoding*) noeudCourant->data)->huffmanCode = code;
        ((struct byteCoding*) noeudCourant->data)->nbBits = nbBits;
        nbBits++;
    }
    
}

// * affichage de l'arbre
void tree_display( struct tree_node * root, int level )
{
    struct tree_node *currentNode = root;
    while (currentNode->rightChildNode != NULL)
    {
        printf("Node :\nOccurence : %d\nByte : %d\nHuffman : %d\nnbBits : %d\n", ((struct byteCoding*) currentNode->leftChildNode->data)->occurrence, 
                                                                                ((struct byteCoding*) currentNode->leftChildNode->data)->byte, 
                                                                                ((struct byteCoding*) currentNode->leftChildNode->data)->huffmanCode, 
                                                                                ((struct byteCoding*) currentNode->leftChildNode->data)->nbBits );
        printf("--------------------\n");
                                                                                
        currentNode = currentNode->rightChildNode;
    }
    printf("Node :\nOccurence : %d\nByte : %d\nHuffman : %d\nnbBits : %d\n", ((struct byteCoding*) currentNode->data)->occurrence, 
                                                                                ((struct byteCoding*) currentNode->data)->byte, 
                                                                                ((struct byteCoding*) currentNode->data)->huffmanCode, 
                                                                                ((struct byteCoding*) currentNode->data)->nbBits );
}
/*
   ()
  /  \
()    ()
     /  \
   ()    ()
*/




int main()
{

    // int tabBinaire[8] = {128, 64, 32, 16, 8, 4, 2, 1};
    // int valDec = 134;

    // for (int i = 0 ; i < 8 ; i++)
    // {
    //     if (valDec >= tabBinaire[i])
    //     {
    //         valDec -= tabBinaire[i];
    //         tabBinaire[i] = 1;
    //         printf("1 ");
    //     }
    //     else
    //     {
    //         tabBinaire[i] = 0;
    //         printf("0 ");
    //     }
    // }

    struct byteCoding bc[256];
    

    tree_resetByteCoding(bc);
    tree_displayByteCoding(bc);
    
    printf("");
    
    char lorem[] = "Lorem ipsum dolor sit amet consectetur, adipisicing elit. Beatae, esse alias sunt accusantium facilis est quia ducimus nemo sequi minima corporis laudantium excepturi odio placeat, ipsa autem hic tenetur ab mollitia facere. Eius voluptatibus facere iusto repellendus temporibus. Repellat, rem molestias illo ducimus dolores quidem vero ea, neque asperiores perspiciatis similique possimus maxime expedita eaque sunt amet cum dolor voluptates officia. Nam, nesciunt. Quaerat quibusdam, fugit consequuntur facere excepturi hic quas doloribus suscipit nulla odio aliquid, laborum quod asperiores, officiis ad molestiae aliquam quis. Quasi omnis ex sed autem aperiam minus qui laborum fugiat laboriosam, molestiae ad, earum fuga incidunt?";
    char hello[] = "Hello wolrd!";
    
    
    tree_countByteOccurrence(hello, strlen(hello), bc);
    tree_displayByteCoding(bc);
    
    
    struct tree_node *arbre = tree_create(bc);
    
    printf("new DBC :\n");
    tree_displayByteCoding(bc);
    
    tree_buildHuffmanCode(arbre, 0, 0);
    tree_display(arbre, 0);
    
    
    

    return 0;
}
